/*
  ==============================================================================

  This is an automatically generated GUI class created by the Introjucer!

  Be careful when adding custom code to these files, as only the code within
  the "//[xyz]" and "//[/xyz]" sections will be retained when the file is loaded
  and re-saved.

  Created with Introjucer version: 3.1.0

  ------------------------------------------------------------------------------

  The Introjucer is part of the JUCE library - "Jules' Utility Class Extensions"
  Copyright 2004-13 by Raw Material Software Ltd.

  ==============================================================================
*/

//[Headers] You can add your own extra header files here...

#include "Patcher.h"

//[/Headers]

#include "ListenPortComponent.h"


//[MiscUserDefs] You can add your own user definitions and misc code here...
//[/MiscUserDefs]

//==============================================================================
ListenPortComponent::ListenPortComponent (const String& game, const String& port)
{
    addAndMakeVisible (portLabel = new Label ("portLabel",
                                              "5678"));
    portLabel->setFont (Font (15.00f, Font::plain));
    portLabel->setJustificationType (Justification::centred);
    portLabel->setEditable (true, true, false);
    portLabel->setColour (TextEditor::textColourId, Colours::black);
    portLabel->setColour (TextEditor::backgroundColourId, Colour (0x00000000));
    portLabel->addListener (this);

    addAndMakeVisible (gameLabel = new Label ("gameLabel",
                                              "EXCOSC Base"));
    gameLabel->setFont (Font (15.00f, Font::bold));
    gameLabel->setJustificationType (Justification::centred);
    gameLabel->setEditable (true, true, false);
    gameLabel->setColour (TextEditor::textColourId, Colours::black);
    gameLabel->setColour (TextEditor::backgroundColourId, Colour (0x00000000));
    gameLabel->addListener (this);


    //[UserPreSize]

	gameLabel->setText(game, dontSendNotification);
	portLabel->setText(port, dontSendNotification);

    //[/UserPreSize]

    setSize (140, 48);


    //[Constructor] You can add your own custom stuff here..
    //[/Constructor]
}

ListenPortComponent::~ListenPortComponent()
{
    //[Destructor_pre]. You can add your own custom destruction code here..
    //[/Destructor_pre]

    portLabel = nullptr;
    gameLabel = nullptr;


    //[Destructor]. You can add your own custom destruction code here..
    //[/Destructor]
}

//==============================================================================
void ListenPortComponent::paint (Graphics& g)
{
    //[UserPrePaint] Add your own custom painting code here..
    //[/UserPrePaint]

    g.setColour (Colour (0xff9696c1));
    g.fillEllipse (115.0f, 12.0f, 24.0f, 24.0f);

    g.setColour (Colour (0xffb0b0ff));
    g.drawEllipse (115.0f, 12.0f, 24.0f, 24.0f, 2.000f);

    g.setColour (Colour (0xffeeece1));
    g.fillRoundedRectangle (1.0f, 1.0f, 126.0f, 46.0f, 10.000f);

    g.setColour (Colour (0xffb0b0ff));
    g.drawRoundedRectangle (1.0f, 1.0f, 126.0f, 46.0f, 10.000f, 2.000f);

    //[UserPaint] Add your own custom painting code here..
    //[/UserPaint]
}

void ListenPortComponent::resized()
{
    portLabel->setBounds (0, 20, 128, 24);
    gameLabel->setBounds (0, 0, 128, 24);
    //[UserResized] Add your own custom resize handling here..
    //[/UserResized]
}

void ListenPortComponent::labelTextChanged (Label* labelThatHasChanged)
{
    //[UserlabelTextChanged_Pre]
    //[/UserlabelTextChanged_Pre]

    if (labelThatHasChanged == portLabel)
    {
        //[UserLabelCode_portLabel] -- add your label text handling code here..
		sendChangeMessage();
        //[/UserLabelCode_portLabel]
    }
    else if (labelThatHasChanged == gameLabel)
    {
        //[UserLabelCode_gameLabel] -- add your label text handling code here..
		sendChangeMessage();
        //[/UserLabelCode_gameLabel]
    }

    //[UserlabelTextChanged_Post]
    //[/UserlabelTextChanged_Post]
}



//[MiscUserCode] You can add your own definitions of your custom methods or any other code here...

//------------------------------------------------------------------------------
void ListenPortComponent::mouseDown(const MouseEvent& event)
{
	if((event.x > 128) && ((event.y > 12) && (event.y < 36)))
	{
        Patcher *patcher(dynamic_cast<Patcher *>(getParentComponent()));

        if(patcher)
	    {
			patcher->startNewConnection(this);
	    }
	}
}

//------------------------------------------------------------------------------
void ListenPortComponent::mouseUp(const MouseEvent& event)
{
	Patcher *patcher(dynamic_cast<Patcher *>(getParentComponent()));

    if(patcher)
	{
		Point<int> parentPoint(getPosition().x + event.x,
							   getPosition().y + event.y);

		patcher->endNewConnection(parentPoint);
	}
}

//------------------------------------------------------------------------------
void ListenPortComponent::mouseDrag(const MouseEvent& event)
{
	Patcher *patcher(dynamic_cast<Patcher *>(getParentComponent()));

    if(patcher)
	{
		Point<int> parentPoint(getPosition().x + event.x,
							   getPosition().y + event.y);

		patcher->dragNewConnection(parentPoint);
	}
}

//[/MiscUserCode]


//==============================================================================
#if 0
/*  -- Introjucer information section --

    This is where the Introjucer stores the metadata that describe this GUI layout, so
    make changes in here at your peril!

BEGIN_JUCER_METADATA

<JUCER_COMPONENT documentType="Component" className="ListenPortComponent" componentName=""
                 parentClasses="public Component, public ChangeBroadcaster" constructorParams="const String&amp; game, const String&amp; port"
                 variableInitialisers="" snapPixels="8" snapActive="1" snapShown="1"
                 overlayOpacity="0.330000013" fixedSize="1" initialWidth="140"
                 initialHeight="48">
  <BACKGROUND backgroundColour="ffffff">
    <ELLIPSE pos="115 12 24 24" fill="solid: ff9696c1" hasStroke="1" stroke="2, mitered, butt"
             strokeColour="solid: ffb0b0ff"/>
    <ROUNDRECT pos="1 1 126 46" cornerSize="10" fill="solid: ffeeece1" hasStroke="1"
               stroke="2, mitered, butt" strokeColour="solid: ffb0b0ff"/>
  </BACKGROUND>
  <LABEL name="portLabel" id="7915a3a72541244c" memberName="portLabel"
         virtualName="" explicitFocusOrder="0" pos="0 20 128 24" edTextCol="ff000000"
         edBkgCol="0" labelText="5678" editableSingleClick="1" editableDoubleClick="1"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="36"/>
  <LABEL name="gameLabel" id="328c386f44d8897a" memberName="gameLabel"
         virtualName="" explicitFocusOrder="0" pos="0 0 128 24" edTextCol="ff000000"
         edBkgCol="0" labelText="EXCOSC Base" editableSingleClick="1"
         editableDoubleClick="1" focusDiscardsChanges="0" fontname="Default font"
         fontsize="15" bold="1" italic="0" justification="36"/>
</JUCER_COMPONENT>

END_JUCER_METADATA
*/
#endif


//[EndFile] You can add extra defines here...
//[/EndFile]
